unit RunDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFmRunOptions = class(TForm)
    RgRunType: TRadioGroup;
    CbRepeatDrivers: TCheckBox;
    EdRepeatDriveTime: TEdit;
    LblTimeUnit1: TLabel;
    CbResetStates: TCheckBox;
    EdResetStateTime: TEdit;
    LblTimeUnit2: TLabel;
    BtnClose: TButton;
    procedure FormCreate(Sender: TObject);
    procedure RgRunTypeClick(Sender: TObject);
    procedure CbRepeatDriversClick(Sender: TObject);
    procedure CbResetStatesClick(Sender: TObject);
    procedure EdRepeatDriveTimeExit(Sender: TObject);
    procedure EdResetStateTimeExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FmRunOptions: TFmRunOptions;

implementation

{$R *.DFM}

uses frontend;

procedure TFmRunOptions.FormCreate(Sender: TObject);
begin
 LblTimeUnit1.Caption := ModelDef.timeunit;
 LblTimeUnit2.Caption := ModelDef.timeunit;
 if MainForm.RunXRepeatedly or MainForm.ResetStates then
   RgRunType.ItemIndex := 1
 else
   RgRunType.ItemIndex := 0;
 if MainForm.RunXRepeatedly then
   begin
     CbRepeatDrivers.Enabled := True;
     CbRepeatDrivers.Checked := True;
     EdRepeatDriveTime.Enabled := True;
     EdRepeatDriveTime.Text := inttostr(MainForm.RepeatDriveTime);
   end
 else
   begin
     CbRepeatDrivers.Enabled := False;
     CbRepeatDrivers.Checked := False;
     EdRepeatDriveTime.Enabled := False;
     EdRepeatDriveTime.Text := '';
   end;
 if MainForm.ResetStates then
   begin
     CbResetStates.Enabled := True;
     CbResetStates.Checked := True;
     EdResetStateTime.Enabled := True;
     EdResetStateTime.Text := inttostr(MainForm.ResetStateTime);
   end
 else
   begin
     CbResetStates.Enabled := False;
     CbResetStates.Checked := False;
     EdResetStateTime.Enabled := False;
     EdResetStateTime.Text := '';
   end;
end;

procedure TFmRunOptions.RgRunTypeClick(Sender: TObject);
begin
 if RgRunType.ItemIndex = 0 then // Normal run
   begin
     CbRepeatDrivers.Enabled := False;
     CbResetStates.Enabled := False;
     EdRepeatDriveTime.Enabled := False;
     EdResetStateTime.Enabled := False;
     MainForm.MINormalRun.Checked := True;
     RunComplete := False;
     Readytorun := False;
   end
 else
   begin
     CbRepeatDrivers.Enabled := True;
     CbResetStates.Enabled := True;
     MainForm.MINormalRun.Checked := False;
     RunComplete := False;
     Readytorun := False;
   end;
end;

procedure TFmRunOptions.CbRepeatDriversClick(Sender: TObject);
begin
  if CbRepeatDrivers.Checked then
    begin
       MainForm.RunXRepeatedly := True;
       EdRepeatDriveTime.Enabled := True;
    end
  else
    begin
       MainForm.RunXRepeatedly := False;
       EdRepeatDriveTime.Enabled := False;
    end;
end;

procedure TFmRunOptions.CbResetStatesClick(Sender: TObject);
begin
  if CbResetStates.Checked then
    begin
       MainForm.ResetStates := True;
       EdResetStateTime.Enabled := True;
    end
  else
    begin
       MainForm.ResetStates := False;
       EdResetStateTime.Enabled := False;
    end;
end;

procedure TFmRunOptions.EdRepeatDriveTimeExit(Sender: TObject);
begin
try
 MainForm.RepeatDriveTime := strtoint(EdRepeatDriveTime.Text);
except
 MessageDlg('Invalid driver repeat time. Run set to Normal run.', mtwarning,
      [mbOK], 0);
 MainForm.MINormalRunClick(FmRunOptions);
 FmRunOptions.FormCreate(FmRunOptions);
end;
end;

procedure TFmRunOptions.EdResetStateTimeExit(Sender: TObject);
begin
try
 MainForm.ResetStateTime := strtoint(EdResetStateTime.Text);
except
 MessageDlg('Invalid state variable reset time. Run set to Normal run.',
      mtwarning, [mbOK], 0);
 MainForm.MINormalRunClick(FmRunOptions);
 FmRunOptions.FormCreate(FmRunOptions);
end;
end;

end.

